## (nowrap)
## -*-Tcl-*- (install)
## -*-Tcl-*- (auto-install)
#####################################################################################
#                                                                                   #
#   m2Mode.tcl:  Macros and bindings for Modula 2 programmers                       #
#                                                                                   #
#                Supports the M2 mode under Alpha >= 7.x                            #
#                useful to programing with MacMETH or RAMSES, both featuring        #
#                a fast Modula-2 language system, freeware available from           #
#                these links:                                                       #
#                                                                                   #
#                   <ftp://ftp.ito.umnw.ethz.ch/pub/mac/RAMSES>                     #
#                   <http://www.ito.umnw.ethz.ch/SysEcol>                           #
#                                                                                   #
#   Installation:  Double-click accompanying file "OPEN-TO-INSTALL"                 #
#   Deinstallation:   Alpha's menu "Config > Packages > Uninstall Package..." M2    #
#                                                                                   #
#   Usage:  See "Modula-2   Help"                                                   #
#                                                                                   #
#   Programing:                                                                     #
#     First implementation was made by Juerg Thoeny <thoeny@ito.umnw.ethz.ch>       #
#     All later work, i.e. reimplementation and improvements, by Andreas Fischlin   #
#     <andreas.fischlin@ito.umnw.ethz.ch>                                           #
#                                                                                   #
#   ou make improvements to this code, please send them to us!  Thanks!             #
#   E-Mail:  mailto:RAMSES@ito.umnw.ethz.ch                                         #
#                                                                                   #
#   Other URLs possibly of interest in the context of this mode:                    #
#                                                                                   #
#   http://www.ito.umnw.ethz.ch/SysEcol                                             #
#   ftp://ftp.ito.umnw.ethz.ch/pub/mac/RAMSES                                       #
#                                                                                   #
#   For details see Help file accompanying this file                                #
#                                                                                   #
#####################################################################################
# 
#   Author    Date        Modification
#   ------    ----        ------------
#   af        21.05.95    Initialization for new Alpha >= 6.0b7 fixed
#                         All module templates fixed to behave usefully
#   af        01.09.95    Initialization for new Alpha >= 6.01 fixed
#                         All module templates fixed to behave usefully
#   af        10.06.96    Fixed a few Modula-2 tcl bugs (see SysEcol
#                         bug list)
#   af        24.06.96    Fixed a indentation and mark file bugs (see SysEcol
#                         bug list)
#   af        28.06.96    Wrap bug fixed and new configuration added to better
#                         support new features, e.g. defineFileSaveFormat
#   af        13.09.96    Fixed a bug when "ErrList.DOK" wasn't found
#                         during start-up
#   af        17.09.96    Fixes for the Alpha-bug with the prefs.tcl
#                         execution (twice, instead of just once)
#                         Testing this script while using Alpha 6.5
#   af        30.12.96    M2MarkFile bug fixed to properly deal with
#                         procIdent ::= char {char | digit }
#                         (jt's version was: procIdent ::= {char} )
#   af        06.03.97    Attempt to improve the nasty, confusing behavior
#                         of wrapComment by giving the user better hints,
#                         however, without being able to really fix the problem
#   af        26.05.97    Template menu did no longer work for unknwon reasons
#                         proc dispatchSubMenuCmds added. Template menu offers
#                         now more all template items
#   af        05.06.97    askForModuleName improved for editing of names
#   af        21.09.97    Improving error messages of launching
#   af        16.09.97    setLnBreakBehavior added which sets now (finally,
#                         sic!) Alpha's global fillColumn, wrapLow, and
#                         wrapHigh variables to avoid annoying line breaks
#                         during programming of long lines.
#   af        22.01.98    Adaptations for Alpha 7.x, M2 is now an ordinary mode
#   af        01.02.98    Fixed long-standing bug with err.ALPHA remaining
#                         open if working file(s) couldn't be opened
#                         Final version having all (even for long outstanding
#                         issues) resolved.
#                         Note configuration uses its own variables, since those
#                         mechanisms were introduced long before Alpha offered
#                         its newPref feature.  Since this script ought to work
#                         also with pre 7 Alphas, this a bit complex
#                         implementation technique is (not yet?) abandoned
#   af        08.02.98    Finalizing M2 mode for release 3.0
#   af        09.02.98    Adding contributions from Tom Fetherston (
#                         M2::parseFuncs, replacement for M2::MarkFile,
#                         M2::insertDivider. Thanks!
#   af        09.02.98    Adding Programmer font flip menu addon by Johan Linde
#                         Thanks!
#   af        11.02.98    Changing behavior of RET. Does now break line and
#                         SHIFT-RET jumps out of line.
#   af        13.02.98    Adding bug fixes by Tom Fetherston for M2::parseFuncs
#                         and new M2::MarkFile, which does now also recognize
#                         modules. Release 3.0 completed.
#   af        17.02.98    V 3.0.1 fixing rshift, lshift menu bug
#   af        19.02.98    V 3.0.2 Omitting PROC from expandWords
#                         adjCurLnToIndent added, new initializiation of
#                         M2modeVars(m2_shellName) and m2_errListDOK if
#                         never configured
#   af        21.02.98    V 3.0.3 Quiet autoconfiguration added
#   af        23.02.98    V 3.0.4 Minor message display fixes. Better (module
#                         specific) behavior of jumpToTemplatePlaceHolder
#                         and M2:carriageReturn
#   af        03.03.98    V 3.0.5 Minor improvements in self-documentation of
#                         newPref vars and a bit of cleaning up, i.e. removing,
#                         of stuff gone obsolete with latest Alpha 7.1b2
#                         openOtherLibModule and section marks added
#   af        09.03.98    V 3.0.6
#                         - Fixed bug in adjCurLnToIndent if no preceeding
#                           white space
#   af        20.03.98    V 3.1b1 Command and Cntrl^Cmd Doubleclick added
#   af        24.03.98    V 3.1b2 JoinToOneSpace added (Ctrl^j no longer equi-
#                         valent to Ctrl^e (find modula-2 error - findNextError)
#   af        27.03.98    V 3.1b3 wrapComment kills extra empty line before *)
#                         Ctrl^m no longer equivalent to CTRL-SHIFT-DOWN but
#                         minimizes now surrounding white space to single blank
#    af       30.03.98    V 3.1b4 Complete revision of M2::MarkFile for new
#                         prefs and fixing bugs in appearance of M-button lists;
#                         Making commentSelection and uncommentSelection behave
#                         more robustly.  Ctrl^c and Ctrl^Shift^c for simple
#                         commenting (uses prefix/suffixString) added.
#                         doM2ShiftLeft/Right selects now line if no selection.
#                         killWholeLine removes now also empty line
#    af       04.04.98    V 3.1
#    af       06.04.98    Fixing bug in menu for Alpha 7.0px but<7.1bx
#    af       09.04.98    V 3.1.1 menu/Menu bug fixed removed again, since Vince
#                         fixed it in Alpha 7.1b6. However, new version checking
#                         added, especially also in OPEN-TO-INSTALL to ensure
#                         user is well informed about compatibility of M2 mode
#                         with certain Alpha versions
#    af       15.04.98    V 3.1.2 Cmd^Cntrl^doubleclik finds now also marks in
#                         any definition module residing within same folder
#    af       17.04.98    New key bindings:
#                         old                         new
#                         ---------------------       -----------------------------
#                         Cmd^Return                  - jumpOutOfLnAndRet (similar
#                         - skipLnReturn              to jumpOutOfLnAndReturn
#                                                     but never indents)
#                         Cmd^Shift^Return            - openNewAbove
#                         - skipPrevLnOpenNew         (skipPrevLnOpenNew dropped)
# 
#                         Cmd^Ctrl^Shift^Return       - skipLnReturn
#    af       20.04.98    M2::DblClickHelper buggy bevavior fixed, skips search in
#                         currently open files if Ctrl^Cmd^Click and search does
#                         in currently open files succeeds only if match exact
#    af       07.05.98    V 3.1.3 Using Juan Fualgeras better completions
#                         Recognizes extension DTF
#    af       12.05.98    V 3.1.4 Searches also in RAMSES Sys DEFs
#                         - removing configureM2Mode from M2 menu if Alpha is 7.x
#                         solution to Juan's suggestion of avoiding use of a trace
#                         which slows down entering of M2 mode.
#    af       13.07.98    Testing phase for V 3.1.4 with Alpha 7.1fc1, 7.1fc2, and
#                         7.1fc3 over => Mode is fit for release
#    af       15.07.98    V 3.1.4 released
#    af       27.08.98    Testing phase for V 3.1.5 with Alpha 7.1fc6, 7.1prerelease
#    af       30.08.98    Adding openFileQuietly replacement by Jonathan Guyer
#    af       30.10.98    V 3.1.6  Fixed bugs in adjCurLnToIndentAbove and
#                         adjCurLnToIndentBelow; showFullName added
#    af       08.12.98    V 3.1.7  Adjustments made for Alpha 7.1p4, i.e. use now
#                         Menu instead of menu if Alpha V >= 7
#    af       01.03.99    V 3.2.0 Finds now also modules if cmd-clicking module name
#                         - bug fixed with finding always marks in currently open
#                           windows
#    af       17.03.99    - M2::MarkFile does now permanently save marks, even if
#                           file was opened as read-only. Useful when
#                           ctrl^cmd^double-clicking names of procedures or modules.
#                         - Double-clicking module names, e.g. in import lists, does
#                           jump to either the corresponding quick reference section
#                           or the definition module as suggested by Juan Falgueras.
#                         - Fixed bug with autoconfiguration in case of a corrupted
#                           desktop or otherwise bad or missing MacMETH or RAMSES
#                           installation. User is now notified. Important, since
#                           lots of mode's function are likely to fail if the
#                           autoconfiguration fails, e.g. cmd^double-click, and user
#                           may not understand at all why.
#    af       22.03.99    V 3.2.1 Colorizing of UNTIL added
#    af       24.03.99    V 3.2.2 intelCutPaste flag turned off
#    af       08.04.99    Minor modifications in section determining version, which
#                         have no effect on the mode
#    af       24.03.99    V 3.2.3 fixing quick reference problem (case sensitivity)
#    af       14.04.99    V 3.2.4 intelCutPaste renamed to smartCutPaste
#                         - M2::correctIndentation fixed to perform according to
#                           specs to support smartPaste feature.
#                         - getIndentation fixed to expand tabs (which are inserted
#                           against all rules by some routines, e.g. by smartPaste
#                           despite there is a routine M2:indentLine, which does
#                           NOT insert a horizontal tab
#                         - doM2ShiftLeft and doM2ShiftRight expand now tabs before
#                           shifting to avoid unsuccessful shift in case there
#                           should be tabs present in the involved line(s)
#                         - prefs indentUsingSpacesOnly now set
#    af       22.04.99    V 3.2.5 attempt to fix some installation problems if
#                         installed from scratch on a machine without a RAMSES shell
#                         - openWorkFiles renamed to M2::openWorkFiles (since it
#                           uses a global binding)
#                         - installDebugFlag and various message production inserted
#                           for easier debugging in case of installation problems
#                         - reportOnShellLaunchFail improved
#                         - copyRing is no longer by default active (slows mode
#                           entering down and is currently rather unstable)
#    af       17.05.99    V 3.2.6 EXPORT added to reserved words
#                         - Uses now a menu icon (ID = 145) to avoid bug of Alpha
#    af       23.05.99    V 3.3b0 complete overhaul to split mode in several files
#                         and to make it Tcl 8 compatible
#    af       27.05.99    V 3.3b1 works with real 7.2 only if I restart System once
#                         from another HFS+ disk volume. On non HFS+ start up disks
#                         no problem.
#                         - distinguishing now wether Alpha is really 7.2, since
#                           only the latter contains the new blue M2 menu resource
#                           (different addMenu and see m2Menu.tcl)
#                         - curAlphaV determined that it contains punctuation
#    af       29.07.99    V 3.3b2 attempt to get M2 mode initialization back to work
#                         - m2Mode.tcl was never really sourced because startup hook
#                           was not really installed. => opening of work object
#                           failed when launching Alpha e.g. via RAMSES shell. Now
#                           fixed.
#    af       02.09.99    V 3.3b3 Attempt to get marking working again. Bug in 
#                         Alpha 7.2.1b10: Aautoloading of procs M2::parseFuncs  
#                         and M2::MarkFile via {}- and M-buttons doesn't work. 
#    af       02.09.99    V 3.3b4 Attempt to improve command double-clicking 
#                         - Moved in m2HelpLookup.tcl the code for <<Is it a 
#                           mark in one of the currently opened file(s)? Skip this if 
#                           Control^Command^Click>> towards the end, so that quick
#                           reference lookup is still possible if concurrently a
#                           definition module is also open, e.g. "SimMaster.DEF" as well
#                           as "ModelWorks Quickreference".
#    af       02.09.99    V 3.4.0 Preparation of release for Alpha 7.3
#                         - m2Marking.tcl more general regexp expressions
#                         - m2Edit.tcl
#    af       02.09.99    V 3.5.0 
#                         - new M2 menu command MakeProjectFile introduced
#                         - new template ife added
#    af       14.02.01    V 3.5.1
#                         - Extension .MOD.MSTR triggers mode
#                         - Fixing version info 
#    af       13.04.01    V 3.5.2
#                         - Extension .m2 .M2 triggers mode so that
#                           Mode Examples Help should work 
#    af       02.05.01    V 3.5.3
#                         - getDirContent extended by parameter dirFiles and recursive
#                         - project files are no longer marked to avoid recompilation
#                           when only opened
#    af       15.06.01    V 3.6.0
#                         - autoEditCompilerFlags added
#    af       29.06.01    V 3.6.1
#                         - autoEditCompilerFlags for IBM fixed, i.e. extending by AuxLib
#    vd       12.09.01    V 3.7.0
#                         - Adjustments for Alpha 7.5 and Tk by Vince Darley
#                           Mode is no longer upward compatible with Alpha versions
#                           earlier than 7.5
#                         - any addDef call replaced by prefs::modified
#                         - in proc adjustM2Prefs from m2AdjPrefs.tcl switch with '--' option
# 			  - any dir separators used in path replaced by join commands
# 			  - in proc defineM2Completions sourcing with uplevel
# 			  - in m2Bindings.tcl using now Bind or unBind instead of bind or unbind
# 			  - in m2Bindings.tcl, m2Config.tcl, m2HelpLookup.tcl, m2Menu.tcl,
# 			    m2Templates.tcl, and m2Utils.tcl
# 			    omitting any conditional statements depending on
# 			    if {$alphaVersionIsAtLeast7} then {
# 			  - in m2CompErr.tcl proc like getCurWord use other routines, e.g. 
# 			    pos::compare etc.
# 			  - M2::forceReadTrigger in m2Config.tcl
# 			  - proc isNotMODModule from m2Edit.tcl and many more procs in here
# 			  - position routines in m2GlobAux.tcl
# 			  - m2Load.tcl added
# 			  - position routines in m2Marking.tcl
# 			  - In m2Menu.tcl  menu::buildSome m2Menu  inserted
# 			  - In m2Mode.tcl proc enterM2Mode calls M2load
# 			  - In m2ShellUse.tcl proc installAEventHandler compares only with V 6.2
# 			  - position routines in m2Templates.tcl
#    af       25.09.01    V 3.7.1
#                         - In m2Prefs.tcl assignment of variables
#                             M2ShellName, M2errDOKFile, M2Author,
#                             M2RightShift, M2LeftShift, M2WrapRightMargin,
#                             M2MaxLineLength, and M2SaveState
#                             M2ShellHome and M2ErrFile
# 			      (the latter 2 are needed to have same
# 			      precondition as resulting from a call to 
# 			      proc adjustShellLaunching from m2AdjPrefs.tcl)
#                           in case the var does not exist to avoid failure
#                           and alert in routine M2::triggerOnRead from m2Config.tcl
#                           when mode is first time entered.
# 			  - m2Load.tcl does source m2Mode.tcl if var curAlphaV does not exist
#                         - Forced loading of mode via a call to proc M2load
# 			    from m2Load.tcl at begin of m2CompErr.tcl and m2ShellUse.tcl
# 			    This ensures that launching Alpha from the RAMSES shell or
# 			    opening work files (Ctrl^0) from within Alpha when mode
# 			    has never been properly initialized will work
#    af       12.10.01    V 3.7.2
#                         - Moving installation info to help
#                         - several cosmetic modifications
#    af       27.10.01    - renaming "M2 Modula-2 Help" back to "Modula-2 Help" as wished by Vince
#    af       13.11.01    V 3.7.3
#                         - Improving m2Help from m2HelpLookup.tcl to mark and color
#                           the help file the standard way
#                         - Improved help file (cosmetic changes only)
#
# 
#  To dos/Known bugs:
#    af       05/02.01    - >= V 3.5.0: wrapText fails unless you run at least 
#                           once wrapComment  -  problem seems to be gone? af, 12.Oct.2001

#===========================================================================
#  Basic initialization of the M2 mode  #
#===========================================================================

namespace eval M2 {}

alpha::mode M2 3.7.3 {
    # activation script, only when we first activate the mode
    enterM2Mode
} {*.mod *.MOD *.def *.DEF *.prj *.PRJ *.DTF *.MOD.MSTR *.m2 *.M2} {
    m2Menu elecCompletions electricReturn
} {
    # This block will be automatically evaluated when Alpha starts
    # up, irrespective of whether M2 mode is ever used.

    # Following binding must be global to allow user to open working
    # files with Ctrl^0 anytime
    Bind '0' <z> M2::openWorkFiles
    
    if {(($tcl_platform(platform) == "macintosh")||($tcl_platform(platform) == "unix" && $tcl_platform(os) == "Darwin"))} {
	# The following allows to force the activation of M2 mode
	# such as this file is scanned and mode can receive anytime
	# a message to open M2 working files
	eventHandler oM2f comp m2EventHandler
    }
    
    # Do final configuration checking to ensure preconditions
    # for M2 mode if M2 is actually activated first time
    hook::register mode::init M2::init M2
    set unixMode(Modula2) {M2}
    # Ramses shell uses creator 'RAMS' for 'TEXT' and 'MoTx'
    # (MDP - Model Definition Programs) files
    set modeCreator(RAMS) M2

    addMenu m2Menu "145" "M2"
} maintainer { 
    "Andreas Fischlin" <RAMSES@ito.umnw.ethz.ch> <http://ito.umnw.ethz.ch/SysEcol> 
} uninstall {
    file delete -force [file join $HOME Tcl Modes "M2 Mode"]
    catch {file delete [file join $HOME Help "Modula-2 Help"]}
    catch {file delete [file join $HOME Tcl Completions M2Completions.tcl]}
    catch {file delete [file join $HOME Tcl Completions "M2 Tutorial.M2"]}
    M2::uninstallAllDefs
    message "M2 deinstallation completed: All files and definitions of M2 mode removed."
} help {
    file "Modula-2 Help"
}

# If installation of mode fails, it may help to set installDebugFlag to "1"
set installDebugFlag 0

if {$installDebugFlag} then {
    alertnote "At very begin of scanning/parsing of m2Mode.tcl"
}

# this procedure is called each time the mode M2 is entered, e.g. by opening a file 
# with the appropriate extension
# (Note, the mode fails if this procedure would be named to M2::enterMode)
proc enterM2Mode {} {
    global installDebugFlag
    if {$installDebugFlag} then {
	alertnote "Entering M2 mode"
    }
    message "Entering M2 mode"
    M2load
}

# Determine current Alpha version (curAlphaV)
# make sure curAlphaV exists always
set curAlphaV [set alpha::version]
regexp {[0-9]+\.[0-9]+} $curAlphaV curAlphaV

# Called the first time M2 mode is entered
proc M2::init {} {
    global installDebugFlag
    message "Initializing M2 mode"
    checkM2Configuration
    setDefltM2Configuration
    defineM2Completions
    message "M2 mode successfully initialized"
    if {$installDebugFlag} then {
	alertnote "In M2::init: M2 mode successfully initialized"
    }
}

# Used during deinstallation to actually remove not just tcl,
# completions, and help files but also these defs added by addDef plus
# the global bindings to really remove all M2 stuff
proc M2::uninstallAllDefs {} {
    global M2TokenFile M2LeftShift M2ShellName M2MaxLineLength M2ShellHome M2ErrFile
    global M2Author M2RightShift M2WrapRightMargin M2errDOKFile M2SaveState
    
    if {[info exists M2TokenFile]} then {unset M2TokenFile ; prefs::modified M2TokenFile}
    if {[info exists M2LeftShift]} then {unset M2LeftShift ; prefs::modified M2LeftShift}
    if {[info exists M2ShellName]} then {unset M2ShellName ; prefs::modified M2ShellName}
    if {[info exists M2MaxLineLength]} then {unset M2MaxLineLength ; prefs::modified M2MaxLineLength}
    if {[info exists M2ShellHome]} then {unset M2ShellHome ; prefs::modified M2ShellHome}
    if {[info exists M2ErrFile]} then {unset M2ErrFile ; prefs::modified M2ErrFile}
    if {[info exists M2Author]} then {unset M2Author ; prefs::modified M2Author}
    if {[info exists M2RightShift]} then {unset M2RightShift ; prefs::modified M2RightShift}
    if {[info exists M2WrapRightMargin]} then {unset M2WrapRightMargin ; prefs::modified M2WrapRightMargin}
    if {[info exists M2errDOKFile]} then {unset M2errDOKFile ; prefs::modified M2errDOKFile}
    if {[info exists M2SaveState]} then {unset M2SaveState ; prefs::modified M2SaveState}
    
    # unBind global bindings
    M2::unsetGlobalBindings
}

# M-button and curly-button don't autload the following functions
# Make sure autoloading works by implementing the two buttons
# procedures the following way

# called by the "{}" button 
proc M2::parseFuncs {} { M2::M2parseFuncs }

# called by the "M" button
proc M2::MarkFile {} { M2::M2MarkFile }

# called by Help file (even if mode not (yet) loaded)
proc M2::openErrListFile {} {
    global M2ShellName
    
    if {[info exists M2ShellName]} then {
	# alertnote "M2ShellName = $M2ShellName"
	ensureset $M2ShellName
	# win::OpenQuietly "[file join [file dirname $HOME] RMS M2Tools ErrList.DOK]" 
	win::OpenQuietly [file join [file dirname $M2ShellName] M2Tools ErrList.DOK]
    } else {
	set msg "Can't open 'ErrList.DOK', since no Modula-2 shell present or var 'M2ShellName' undefined! "
	append msg "Hint: If you have a Modula-2 shell on your system, open a new window, enter M2 mode, and close it. Then try once more."
	alertnote $msg
    }
}



